#include "Arduino.h"
#include <Adafruit_NeoPixel.h>

class myNeoPixel : public Adafruit_NeoPixel{
  public:
    myNeoPixel(uint8_t _n, uint16_t _p);
    void setup();
    void fadeIn(uint8_t _r, uint8_t _g, uint8_t _b,
                uint8_t _d);
    void fadeOut(uint8_t _d);
};

myNeoPixel::myNeoPixel(uint8_t _n, uint16_t _p)
 : Adafruit_NeoPixel(_n, _p){
  // constructor
}

void myNeoPixel::setup(){
  begin();
  for(uint16_t i=0; i<numPixels(); i++){
    setPixelColor(i, Color(0, 0, 0));
  }
  show();
}

void myNeoPixel::fadeIn(uint8_t _r, uint8_t _g, uint8_t _b,
                        uint8_t _d){
  unsigned long duration = _d * 2;
  unsigned long startTime = millis();
  for(;;){
    unsigned long elapsedTime = millis() - startTime;
    if(elapsedTime > duration) break;
    uint8_t r = _r * elapsedTime / duration;
    uint8_t g = _g * elapsedTime / duration;
    uint8_t b = _b * elapsedTime / duration;
    for(uint16_t i=0; i<numPixels(); i++){
      setPixelColor(i, Color(r, g, b));
    }
    show();
    delay(1);
  }
  for(uint16_t i=0; i<numPixels(); i++){
    setPixelColor(i, Color(_r, _g, _b));
  }
  show();
}

void myNeoPixel::fadeOut(uint8_t _d){
  unsigned long duration = _d * 2;
  uint32_t startColor = getPixelColor(0);
  uint8_t sr  = (uint8_t)(startColor >> 16);
  uint8_t sg  = (uint8_t)(startColor >>  8);
  uint8_t sb  = (uint8_t)startColor;
  unsigned long startTime = millis();
  for(;;){
    unsigned long elapsedTime = millis() - startTime;
    if(elapsedTime > duration) break;
    uint8_t r = sr * (1 - (float)elapsedTime / duration);
    uint8_t g = sg * (1 - (float)elapsedTime / duration);
    uint8_t b = sb * (1 - (float)elapsedTime / duration);
    for(uint16_t i=0; i<numPixels(); i++){
      setPixelColor(i, Color(r, g, b));
    }
    show();
    delay(1);
  }
  for(uint16_t i=0; i<numPixels(); i++){
    setPixelColor(i, Color(0, 0, 0));
  }
  show();
}

