#include "Arduino.h"
#include <ESP8266WiFi.h>
#include "myNeoPixel.h"
#include "rain.h"
#include "temperature2Color.h"

myNeoPixel led = myNeoPixel(1, 4);

// Wi-Fiネットワーク設定
const char* ssid = "********";
const char* pass = "********";

// Webサーバ上のプログラムのURL
const char* host = "tetsuakibaba.jp";
const char* path = "/test/fuji-chan.php";

// 取得したい場所のアメダス・火山情報のURL
const char* url_temp = "https://tenki.jp/amedas/5/25/50066.html"; // Mt.Fuji
const char* url_vol = "http://tenki.jp/bousai/volcano/314/index.html"; // Mt.Fuji

// Wi-Fiへ接続する関数
void connect() {
  Serial.println();
  Serial.println();
  Serial.print("Connecting to ");
  Serial.println(ssid);
  WiFi.begin(ssid, pass);
  while (WiFi.status() != WL_CONNECTED) {
    //delay(500);
    led.fadeIn(50, 50, 50, 500);
    led.fadeOut(500);
    Serial.print(".");
  }
  Serial.println();
  Serial.print("WiFi connected ( IP address: ");
  Serial.print(WiFi.localIP());
  Serial.println(" )");
}

// Webサーバからデータを取得する関数
void update(float* _temperature, int* _funkaLevel, float* _precipitation) {
  // (1)Webサーバーに接続する（TCP接続）
  Serial.println();
  Serial.print("connecting to ");
  Serial.println(host);
  WiFiClient client;
  const int httpPort = 80; // HTTP通信のポート番号は80
  if (!client.connect(host, httpPort)) {
    Serial.println("connection failed");
    return;
  }
  // (2)要求するファイルのURLを用意する
  String url = path;
  url += "?url_temp=";
  url += url_temp;
  url += "&url_vol=";
  url += url_vol;
  Serial.print("Requesting URL: ");
  Serial.println(url);
  // (3)HTTPリクエストをWebサーバーに送信する
  client.print(String("GET ") + url + " HTTP/1.1\r\n" +
               "Host: " + host + "\r\n" +
               "Connection: close\r\n\r\n");
  unsigned long timeout = millis();
  while (client.available() == 0) {
    if (millis() - timeout > 5000) {
      Serial.println(">>> Client Timeout !");
      client.stop();
      return;
    }
  }
  // (4)HTTPレスポンスから必要なデータを取り出す
  while (client.available()) {
    String line = client.readStringUntil('\r');
    //Serial.print(line); // この行を有効にするとHTTPレスポンスの全体が確認できます。
    // 気温、噴火レベル、降水量の順番で並んでおり、カンマで区切られています。
    int commaIndex = line.indexOf(",");          // 行の先頭から何文字目に
    int lastCommmaIndex = line.lastIndexOf(","); // 最初のカンマと2つめのカンマがあるか
    if (commaIndex >= 0) {
      *_temperature = line.substring(0, commaIndex).toFloat();
      *_funkaLevel = line.substring(commaIndex + 1).toInt();
      *_precipitation = line.substring(lastCommmaIndex + 1).toFloat();
    }
  }
  Serial.println();
  Serial.println("closing connection");

  Serial.print("temperature: ");
  Serial.println(*_temperature);
  Serial.print("volcano warning level: ");
  Serial.println(*_funkaLevel);
  Serial.print("precipitation: ");
  Serial.println(*_precipitation);
  
  Serial.println(">>> Fuji-chan updated!");
}

