#include "Arduino.h"

const int speaker = 16;

float mapfloat(float x, float in_min, float in_max, float out_min, float out_max) {
  return (x - in_min) / (in_max - in_min) * (out_max - out_min) + out_min;
}

// 雨音を作る関数
void makeRainSound(float _mm) {
  float mm = _mm;

  // 降水量が0.1[mm/h]以下のときは雨音を鳴らさない．
  if ( mm < 0.1 ) {
    return;
  }

  // 降水量が20[mm/h]以上のときは雨音の激しさは最大
  if ( mm > 20 ) {
    mm = 20;
  }

  // ある範囲の数値を，別の範囲に変換する関数
  mm = mapfloat(mm, 0.0, 20.0, 200, 10); // 降水量が少ないほど雨音が鳴りづらくなる
  if ( random(1, (int)mm) == 1 ) {
    tone(speaker, (int)random(500, 1500), (long)random(1, 3));
  }
}

