#include "myNeoPixel.h"        // Fujichan用のLED制御プログラム
#include "rain.h"              // Fujichanの雨音プログラム
#include "temperature2Color.h" // Fujichanの気温を色に変換するプログラム

myNeoPixel led = myNeoPixel(1, 4); // ledの数は1つ，LEDにつないだピンは4番
// int speaker = 9; // rain.hに書いてあるので，ここでは書かない

float temperature   = 0; // 気温（単位は[°C]）
int   funkaLevel    = 0; // 噴火警戒レベル
float precipitation = 0; // 降水量（単位は[mm/h]）

void setup() {
  led.setup();             // LEDの初期設定
  Serial.begin(115200);    // シリアル通信を開始する
  Serial.println("START"); // シリアルモニターに"START"と表示
}

void loop() {
  if ( Serial.available() > 0 ) {    // もしデータが届いていたら
    float val = Serial.parseFloat(); // 変数を用意して取り出す
    if ( val < 1000 ) {  // 受け取ったデータが1000より小さいなら
      temperature = val; // 受け取ったデータを気温に設定
      // ここに，変数temperatureを使って，気温が更新された時の処理を書いてみましょう
      /* 気温が更新された時の処理．ここから */
      


      

      /* ここまで */
    }
    else if ( val >= 1000 && val < 2000) { // 受け取ったデータが1000以上かつ2000より小さいなら
      funkaLevel = val - 1000.0;           // 受け取ったデータから1000引いた数を噴火警戒レベルに設定
      // ここに，噴火警戒レベルが更新された時の処理
      if(funkaLevel >= 4){               // もし噴火警戒レベルが4以上なら
        for(int i=0; i<funkaLevel; i++){ // 噴火警戒レベルの数だけ警告音を鳴らす
          tone(speaker, 500);
          delay(400);
          noTone(speaker);
          delay(100);
        }
      }
    }
    else if ( 2000 <= val && val < 3000 ) { // 受け取ったデータが2000以上なら
      precipitation = val - 2000.0;         // 受け取ったデータから2000引いた数を降水量に設定
      // ここに，降水量が更新された時の処理
    }
    else if ( (int)val == 4001 ) { // 受け取ったデータが4001なら
      led.fadeOut(500);            // LEDを消す
      precipitation = 0.0;         // 雨音を止める
      return;
    }
    else { // それ以外なら何もしない
      return;
    }
    // シリアルモニタに3つのデータを表示
    Serial.println();
    Serial.print("temperature: ");
    Serial.println(temperature);
    Serial.print("volcano warning level: ");
    Serial.println(funkaLevel);
    Serial.print("precipitation: ");
    Serial.println(precipitation);
  }
  makeRainSound(precipitation); // Fujichan用の雨音を鳴らす関数
  delay(1);
}
