#include "Arduino.h"

struct RGBColor
{
  uint8_t r;
  uint8_t g;
  uint8_t b;
};

float dist(float _temperature, float _s, float _u)
{
  return exp( -1.0 * pow(_temperature - _u, 2) / (2.0 * _s * _s));
}
/*
   Based on normal distribution function,
   this returns r,g,b color to be mathed
   fuji-chan color
*/

// xposition
float u_red = 15; // average
float u_green = 5;
float u_blue = -20;
float u_white = 0;
float deviation = 40;
float temp_max = 20;
float temp_min = 10;

void setMaxMinTemprature(float _min, float _max)
{
  u_red = _max; // average
  u_blue = _min;
  u_green = _min+2.0*(_max-_min)/3.0;
  u_white = 0;
  deviation = _max - _min;
  temp_max = _max;
  temp_min = _min;
}

RGBColor temperature2Color(float _temp)
{
  float s_red = sqrt(deviation); // sigma: deviation
  float s_green = sqrt(deviation);
  float s_blue = sqrt(deviation);
  float s_white = sqrt(deviation);


  // distribution equation:
  // y=(1/(sqrt(2*3.14*s*s))) * exp( -1.0*pow(x-10,2)/(2*s*s))
  RGBColor c;
  int r, g, b;
  if ( _temp <= temp_min )_temp = temp_min;
  if ( _temp >= temp_max )_temp = temp_max;
  r = 255 * (1.0 * dist(_temp, s_red, u_red) + 0.5 * dist(_temp, s_white, u_white));
  g = 255 * (0.5 * dist(_temp, s_green, u_green) + 0.5 * dist(_temp, s_white, u_white));
  b = 255 * (1.0 * dist(_temp, s_blue, u_blue) + 0.5 * dist(_temp, s_white, u_white));

  if ( r > 255 )r = 255;
  if ( g > 255 )g = 255;
  if ( b > 255 )b = 255;
  float luminance = ( 0.298912 * r + 0.586611 * g + 0.114478 * b );
  while ( luminance < 120 ) {
    if (r < 255)r++;
    if (g < 255)g++;
    if (b < 255)b++;
    luminance = ( 0.298912 * r + 0.586611 * g + 0.114478 * b );
  }
  while ( luminance > 130 ) {
    if ( r > 0 )r--;
    if ( g > 0 )g--;
    if ( b > 0)b--;
    luminance = ( 0.298912 * r + 0.586611 * g + 0.114478 * b );
  }

  c.r = (byte)r;
  c.g = (byte)g;
  c.b = (byte)b;
  return c;
}
