#include "FujichanClient.h"

#define UPDATE_INTERVAL 10 // 更新間隔[秒]

float temperature   = 0; // 気温（単位は[°C]）
int   funkaLevel    = 0; // 噴火警戒レベル
float precipitation = 0; // 降水量（単位は[mm/h]）

// Wi-Fiネットワーク設定
const char* ssid = "IA-Interface-UP";
const char* pass = "7bxbvsibvn4uf";

// Webサーバ上のプログラムのURL
const char* host = "tetsuakibaba.jp";
const char* path = "/test/fuji-chan.php";

// 取得したい場所のアメダス・火山情報のURL
const char* url_temp = "https://tenki.jp/amedas/3/22/49036.html"; // Mt.Fuji
const char* url_vol = "http://tenki.jp/bousai/volcano/314/index.html"; // Mt.Fuji

void setup() {
  led.setup();             // LEDの初期設定
  Serial.begin(115200);    // シリアル通信を開始する
  Serial.println("START"); // シリアルモニタに"START"と表示

  // Wi-Fiへ接続する関数
  connect();

  // Webサーバからデータを取得する関数
  update(&temperature, &funkaLevel, &precipitation); // 情報を更新します

  setMaxMinTemprature(-10.0, 30);
  RGBColor color = temperature2Color(temperature);
  led.setColor(color.r, color.g, color.b);    // LEDの更新
}

void loop()
{
  // 温度、噴火警告レベル、降水量情報を更新する
  update(&temperature, &funkaLevel, &precipitation);
  if(temperature >=30.0){
    led.setColor(255,0,0);
  }
  else{
    led.setColor(0,255,0);
  }
  //RGBColor color = temperature2Color(temperature);
  //led.setColor(color.r, color.g, color.b);

  delay(UPDATE_INTERVAL * 1000);
}
